var background=(function(){"use strict";function _(a){return a==null||typeof a=="function"?{main:a}:a}const r=globalThis.browser?.runtime?.id?globalThis.browser:globalThis.chrome;class l extends Error{constructor(e,t,s){super(e),this.code=t,this.statusCode=s,this.name="ThothAPIError"}}class S{baseUrl;apiKey;constructor(e){this.baseUrl=e.baseUrl||"https://www.usethoth.com/api",this.apiKey=e.apiKey}async analyzeContent(e){try{const t=await fetch(`${this.baseUrl}/chrome-extension/analyze`,{method:"POST",headers:{"X-API-Key":this.apiKey,"Content-Type":"application/json"},body:JSON.stringify(e)});if(!t.ok){let o="Request failed",c;try{const i=await t.json();i?.error&&(o=i.error),i?.code&&(c=i.code)}catch{}throw new l(o,c,t.status)}return await t.json()}catch(t){throw t instanceof l?t:new l(t instanceof Error?t.message:"Unknown error occurred")}}async getAnalysisStatus(e){try{const t=await fetch(`${this.baseUrl}/chrome-extension/analyze?requestId=${e}`,{method:"GET",headers:{"X-API-Key":this.apiKey}});if(!t.ok){let o="Failed to get analysis status";try{const c=await t.json();c?.error&&(o=c.error)}catch{}throw new l(o,void 0,t.status)}return await t.json()}catch(t){throw t instanceof l?t:new l(t instanceof Error?t.message:"Unknown error occurred")}}async getBrandStyles(){try{const e=await fetch(`${this.baseUrl}/v1/brand-styles`,{method:"GET",headers:{"X-API-Key":this.apiKey}});if(!e.ok){let s="Failed to fetch brand styles";try{const o=await e.json();o?.error&&(s=o.error)}catch{}throw new l(s,void 0,e.status)}return await e.json()}catch(e){throw e instanceof l?e:new l(e instanceof Error?e.message:"Unknown error occurred")}}async analyzeWithRetry(e,t=3){for(let s=0;s<t;s++)try{return await this.analyzeContent(e)}catch(o){if(o instanceof l&&o.code==="RATE_LIMIT_EXCEEDED"&&s<t-1){const c=Math.pow(2,s)*1e3;await new Promise(i=>setTimeout(i,c));continue}throw o}throw new l("Max retries exceeded")}async pollForCompletion(e,t={}){const{maxAttempts:s=30,intervalMs:o=2e3}=t;for(let c=0;c<s;c++){const i=await this.getAnalysisStatus(e);if(i.data.status==="completed"||i.data.status==="failed")return i;c<s-1&&await new Promise(g=>setTimeout(g,o))}throw new l("Analysis timeout - max polling attempts exceeded","TIMEOUT")}}function A(a){if(a instanceof l)switch(a.code){case"UNAUTHORIZED":return"Invalid API key. Please check your settings.";case"RATE_LIMIT_EXCEEDED":return"Rate limit exceeded. Please try again later.";case"INVALID_REQUEST":return"Invalid request. Please check the URL and try again.";case"SCREENSHOT_FAILED":return"Failed to capture screenshot. The page may not be accessible.";case"ANALYSIS_FAILED":return"Failed to analyze content. Please try again.";case"TIMEOUT":return"Request timed out. Please try again.";default:return a.message}return a instanceof Error?a.message:"An unknown error occurred"}const n={API_KEY:"apiKey",BRAND_STYLE_ID:"brandStyleId",RESPONSE_LENGTH:"responseLength",CUSTOM_CONTEXT:"customContext",BRAND_STYLES:"brandStyles",BRAND_STYLES_TIMESTAMP:"brandStylesTimestamp",ANALYSIS_CACHE:"analysisCache"},E=300*1e3,f=3600*1e3;class d{static async saveApiKey(e){if(!e.startsWith("thoth_"))throw new Error('Invalid API key format. Must start with "thoth_"');await r.storage.sync.set({[n.API_KEY]:e})}static async getApiKey(){return(await r.storage.sync.get(n.API_KEY))[n.API_KEY]}static async removeApiKey(){await r.storage.sync.remove(n.API_KEY)}static async saveBrandStyleId(e){e===null?await r.storage.sync.remove(n.BRAND_STYLE_ID):await r.storage.sync.set({[n.BRAND_STYLE_ID]:e})}static async getBrandStyleId(){return(await r.storage.sync.get(n.BRAND_STYLE_ID))[n.BRAND_STYLE_ID]}static async saveResponseLength(e){await r.storage.sync.set({[n.RESPONSE_LENGTH]:e})}static async getResponseLength(){return(await r.storage.sync.get(n.RESPONSE_LENGTH))[n.RESPONSE_LENGTH]}static async saveCustomContext(e){await r.storage.sync.set({[n.CUSTOM_CONTEXT]:e})}static async getCustomContext(){return(await r.storage.sync.get(n.CUSTOM_CONTEXT))[n.CUSTOM_CONTEXT]}static async cacheBrandStyles(e){await r.storage.local.set({[n.BRAND_STYLES]:e,[n.BRAND_STYLES_TIMESTAMP]:Date.now()})}static async getCachedBrandStyles(){const e=await r.storage.local.get([n.BRAND_STYLES,n.BRAND_STYLES_TIMESTAMP]),t=e[n.BRAND_STYLES],s=e[n.BRAND_STYLES_TIMESTAMP];return!t||!s?null:Date.now()-s>f?(await r.storage.local.remove([n.BRAND_STYLES,n.BRAND_STYLES_TIMESTAMP]),null):t}static async cacheAnalysis(e,t,s){const o=this.getAnalysisCacheKey(e,t),i=(await r.storage.local.get(n.ANALYSIS_CACHE))[n.ANALYSIS_CACHE]||{};i[o]={data:s,timestamp:Date.now()},await r.storage.local.set({[n.ANALYSIS_CACHE]:i})}static async getCachedAnalysis(e,t){const s=this.getAnalysisCacheKey(e,t),c=(await r.storage.local.get(n.ANALYSIS_CACHE))[n.ANALYSIS_CACHE]||{},i=c[s];return i?Date.now()-i.timestamp>E?(delete c[s],await r.storage.local.set({[n.ANALYSIS_CACHE]:c}),null):i.data:null}static async clearExpiredCache(){const t=(await r.storage.local.get(n.ANALYSIS_CACHE))[n.ANALYSIS_CACHE]||{},s=Date.now(),o={};for(const[c,i]of Object.entries(t))s-i.timestamp<=E&&(o[c]=i);await r.storage.local.set({[n.ANALYSIS_CACHE]:o})}static async clearAllCache(){await r.storage.local.remove([n.BRAND_STYLES,n.BRAND_STYLES_TIMESTAMP,n.ANALYSIS_CACHE])}static getAnalysisCacheKey(e,t){return`${e}:${t}`}static async getAllSettings(){const e=await r.storage.sync.get([n.API_KEY,n.BRAND_STYLE_ID,n.RESPONSE_LENGTH,n.CUSTOM_CONTEXT]);return{apiKey:e[n.API_KEY],brandStyleId:e[n.BRAND_STYLE_ID],responseLength:e[n.RESPONSE_LENGTH],customContext:e[n.CUSTOM_CONTEXT]}}}const C=_(()=>{console.log("Thoth background script loaded",{id:r.runtime.id}),r.runtime.onMessage.addListener((a,e,t)=>(console.log("Received message:",a),a.type==="ANALYZE_CONTENT"?(N(a,e.tab?.id),!1):a.type==="GET_BRAND_STYLES"?(I(a).then(s=>{console.log("[Background] Sending response via sendResponse:",s),t(s)}).catch(s=>{console.error("[Background] Error in handleGetBrandStyles:",s),t({type:"API_ERROR",payload:{error:s.message||"Unknown error"}})}),!0):!1)),r.action.onClicked.addListener(async a=>{console.log("Extension icon clicked"),await T(a.id)})});async function N(a,e){try{const t=await d.getAllSettings();if(!t.apiKey)throw new Error("API key not configured. Please set up your API key in the settings.");const{url:s,platform:o,actionType:c,context:i,brandStyleId:g,responseLength:R,forceRegenerate:P}=a.payload;if(P)console.log("Force regenerate requested, bypassing cache");else{const p=await d.getCachedAnalysis(s,c);if(p){console.log("Using cached analysis"),await w(p,e);return}}const B=new S({apiKey:t.apiKey});console.log("Making API request...");const h=await B.analyzeWithRetry({url:s,platform:o,actionType:c,brandStyleId:g,context:i,responseLength:R});if(h.success)console.log("Analysis successful"),await d.cacheAnalysis(s,c,h.data),await w(h.data,e),e&&await T(e);else throw new Error("Analysis failed")}catch(t){console.error("Analysis error:",t);const s=A(t);await m(s,e)}}async function w(a,e){const t={type:"ANALYSIS_COMPLETE",payload:{data:a}};if(e)try{await r.tabs.sendMessage(e,t)}catch(s){console.error("Failed to send message to tab:",s)}try{await r.runtime.sendMessage(t)}catch{console.log("Side panel not open, will receive message when opened")}}async function m(a,e){const t={type:"ANALYSIS_ERROR",payload:{error:a}};if(e)try{await r.tabs.sendMessage(e,t)}catch(s){console.error("Failed to send error to tab:",s)}try{await r.runtime.sendMessage(t)}catch{console.log("Side panel not open")}}async function I(a){try{console.log("[Background] Handling GET_BRAND_STYLES request");const{apiKey:e}=a.payload,t=await d.getCachedBrandStyles();if(t)return console.log("[Background] Using cached brand styles, count:",t.length),console.log("[Background] Cached brand styles:",t),{type:"BRAND_STYLES_RESPONSE",payload:{brandStyles:t}};console.log("[Background] No cached brand styles, fetching from API...");const o=await new S({apiKey:e}).getBrandStyles();if(console.log("[Background] API response:",o),o.success){console.log("[Background] Brand styles fetched successfully, count:",o.data.length),console.log("[Background] Brand styles data:",o.data),await d.cacheBrandStyles(o.data),console.log("[Background] Brand styles cached successfully");const c={type:"BRAND_STYLES_RESPONSE",payload:{brandStyles:o.data}};return console.log("[Background] Returning response message:",c),c}else throw new Error("Failed to fetch brand styles")}catch(e){return console.error("[Background] Get brand styles error:",e),{type:"API_ERROR",payload:{error:A(e)}}}}async function T(a){try{a?await r.sidePanel.open({tabId:a}):await r.sidePanel.open(),console.log("Side panel opened")}catch(e){console.error("Failed to open side panel:",e)}}function Y(){}function y(a,...e){}const L={debug:(...a)=>y(console.debug,...a),log:(...a)=>y(console.log,...a),warn:(...a)=>y(console.warn,...a),error:(...a)=>y(console.error,...a)};let u;try{u=C.main(),u instanceof Promise&&console.warn("The background's main() function return a promise, but it must be synchronous")}catch(a){throw L.error("The background crashed on startup!"),a}return u})();
